#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/3tKSWw

/* Creative Commons Licence Attribution-NonCommercial-ShareAlike 
 * phreax 2020

 * Attempt to animate an artwork of my friend Martin.
*/

#define PI 3.141592
#define TAU PI*2.
#define SIN(x) (sin(x)*.5+.5)

#define hue(v) ( .6 + .6 * cos( 6.3*(v) + vec3(0,23,21) ) )

#define BEND .8     
#define COUNT 10.
#define DISTORT 0.0

vec3[] palette = vec3[](vec3(1.0, .2, 0), vec3(.0, .9, .4), vec3(.1, .7, .9), vec3(1, .9, 0));
float tt, fid, id;
int mat;
vec3 inter;


mat2 rot(float a) { return mat2(cos(a), sin(a), -sin(a), cos(a));}

float hash11(float x) {
	return fract(sin(437765.44*x)*345.63);
}

float hash21(vec2 p) {
    return fract(sin(dot(p, vec2(2434.423,23.34)))*3228324.345);
}


vec2 kalei(vec2 uv) { 

    float n = 4.;
    float r = TAU/n;
    
    for(float i=0.; i<n; i++) {     
    	uv = abs(uv);
        uv.x -= .2*i+.2;
    	uv *= rot(r*i-.09*tt);
    }
    
    uv = abs(uv) - (sin(.15*tt)+1.2);

    return uv;
}

// Draw a triangle
float triangle(vec2 uv) {
    
  int N = 3;
  float a = atan(uv.x,uv.y)+PI;
  float r = TAU/float(N);

  float d = cos(floor(.5+a/r)*r-a)*length(uv);

  return 1.0-smoothstep(.5,.6, d);
}


// Draw a hollow frame
float triangle_frame(vec2 uv, float r) {
    
    float d;
    d += triangle(uv);
    d -= triangle(uv/(1.-r));
    return d;
    
}

vec3 spiral(vec2 uv, float i) {  
    uv *= rot(i*3.14+tt);
    uv += DISTORT*sin(vec2(5)*uv.yx);
	return triangle_frame(uv, .04)*hue(i+tt*.2);
}

// From my Electric Sheep: https://www.shadertoy.com/view/wlV3zy
vec3 dream( vec2 uv )
{

    vec3 col = vec3(0);
    tt = iTime;
    
    uv *= 5.;
    uv = kalei(uv);

    float s = 1./COUNT;
	
    for(float i=0.; i<1.; i+=s) {   
        float z = fract(i-.1*tt);
        vec2 UV = uv;
        col += spiral(UV*z, i)*3.;
    }
    col +=  0.5/(abs(uv.x)+abs(uv.y))*(.8+.2*hue(.2*tt)); 
 
    return col;
}

vec2 moda(vec2 p, float repetitions, float offs, out float id) {
	float angle = 2.*PI/repetitions;
	float a = atan(p.y, p.x) + angle/2. +offs;
    id = floor(a/angle);
	a = mod(a,angle) - angle/2.;
    if (abs(id) >= (repetitions/2.)) id = abs(id);
	return vec2(cos(a), sin(a))*length(p);
}

float box(vec2 p, vec2 s)
{
  p = abs(p);
  return max(p.x-s.x, p.y-s.y);
}

float bo(vec3 p, vec3 s) {
	vec3 q = abs(p) - s;   
    return length(max(q, 0.0)) + min(max(q.x, max(q.y, q.z)), 0.);
}

// single leaf shape
float leaf(vec2 uv, float r, float cp) {

    float f = uv.y < 0. ? 1.2 : .7;
    float  rp = uv.y < 0. ? 2.3 : 1.8;
    float x = length(vec2(uv.x, pow(uv.y * f, cp)));
    float y = r - pow(uv.y * f, rp);
    float v = smoothstep(x, x + 16. / iResolution.y, y);
    v *= pow(length(uv-vec2(.1, -.25))+.5,1.3); // bit of 3d look
    return clamp(0., 1.5, v);
}

vec2 repeat(vec2 p, vec2 s, out vec2 id) {
	id = floor(p*s);
    return fract(p*s)-.5;
}

float repeat(float p, float s, out float id) {
	id = floor(p*s);
    return fract(p*s)-.5;  
}

// blinking dots
float dots(vec2 uv, float r, float s) {
    uv.x *= s;
    
    float did;
	uv.y = repeat(uv.y, s, did);

    float d = length(uv) - r;
    return smoothstep(16./iResolution.y, 0., d)*SIN(-tt*4.+did*.9);
}

// From shadertoy user curena: https://www.shadertoy.com/view/Mlj3zc
vec2 inversion(vec2 p) {

    vec2 bp = p;
    float r    = sqrt(length( p ));
   
    bp.y += 0.4*(p.x*p.x)-.03;
    return normalize(p)/(r*0.05) 
              + vec2(1.,-sign(bp.y)*4.5*tt);
}

vec3 leaf_pattern(vec2 uv, vec2 off) {
	vec2 id;
    uv = repeat(uv, vec2(.14), id);
    uv *= 1.2;
    id += off;
    float h = hash21(id);
    uv *= rot(h*.4*sin(tt));
    vec3 col = vec3(0);
    col += leaf(uv-vec2(.3, 0), .2, 8.)*palette[int(4.*SIN(id.x*8.+mod(id.y, 4.)))];
    // blinking leafs
    col *= mix(1., 3., step(.6, SIN(id.x*.3+mod(id.y, 5.)+tt*.5)*h));
    col += leaf(uv+vec2(.3, 0), .2, 8.)*palette[int(4.*SIN(id.x*8.-4.+mod(id.y, 4.)))];
    return col;
}

vec3 overlay(vec3 c1, vec3 c2) {
    return mix(c1, c2, (1.-step(dot(c2, vec3(1)), 0.))); 
}

vec3 leaf_layers(vec2 uv) {
    vec2 uvb = uv;
    uv = inversion(uv);
    uv += sin(uv.yy*vec2(0.5, 0.24))*.2;
    
    uv.y *= sign(uvb.y);
	vec3 c1 = leaf_pattern(uv, vec2(0));
    vec3 c2 =leaf_pattern(uv+vec2(.1, 2.2), vec2(3,3)); 
    vec3 c3 =leaf_pattern(uv+vec2(2.3, 4.24), vec2(4,4));
    vec3 c4 =leaf_pattern(uv+vec2(1.9, 1.3), vec2(6,2));
    
    return overlay(c1*.7, overlay(c2*.8, overlay(c3*.9, c4)))*1.-pow(length(uvb)+.4, 4.);          
}

float mask_texture(vec2 p) {
    vec2 bp = p;
    float d = box(p-vec2(0, .4), vec2(.02, .9));
    p.x = abs(p.x);
    d = min(d, box(p-vec2(0.3, .65), vec2(.09, .03)));
    d = min(d, box(p-vec2(0.33, .5), vec2(.12, .03)));
    d = min(d, box(p-vec2(0.36, .35), vec2(.14, .03)));
    d = max(d, -box(p*rot(.3)-vec2(0.58, .4), vec2(.03, .26)));
    d = min(d, box(p-vec2(0.25, -.05), vec2(.03, .25)));
    d = min(d, box(p-vec2(0.36, -.33), vec2(.14, .03)));
    d = min(d, box(p*rot(-.25)-vec2(0.35-sin((p.y-.02)*2.6)*.25, -.5), vec2(.02, .3)));
    float c = smoothstep(0., 5./iResolution.y, d);

    d = length(p-vec2(0, -.7)) -.2;
    c *=  smoothstep(0., 5./iResolution.y, abs(d-.01)-.02);
    return c;
}


float box(vec3 p, vec3 r) {
	vec3 d = abs(p) - r;
    return length(max(d, 0.0)) + 
        min(max(d.x, max(d.y, d.z)), 0.0);
}


float mask(vec3 p) {

    vec3 bp = p;
    
    p.y /= 1.5;
    p.z *= 1.5;

    float d = length(p) - .8;

    float b = box(abs(bp)-vec3(0.7, 0, 0), vec3(.2, .2, 1.));
    d = max(max(d, -p.z), -b);
    return d*.64;
}

// capped cylinder
float cylc( vec3 p, float h, float r )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - vec2(h,r);
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

vec3 transform_mask(vec3 p) {
    p.xz = moda(p.xz,12., tt*.8, id);
    p.y += .3*sin(tt*sin(id*14.523)*5.);
    p.x = abs(p.x)-3.8;
    p.xz *= rot(PI*1.5);
    return p;
    
}

vec3 transform_box1(vec3 p) {
    vec3 bp = p;
    p.x = abs(p.x) - 1.5;
    p.x += sin(p.y*.2+PI*.5)*5.-5.;
    p.x += sin(p.y*2.-PI/2.)*.4;
    p.xz *= rot(bp.y*PI*.2-tt);
    return p;
}


vec3 transform_box2(vec3 p) {
    p.x = abs(p.x)-5.;
    p.xy += .01*(p.z*p.z)-.3;
    return p;
}


float map(vec3 p) {
 	vec3 mp = transform_mask(p);
    
    vec3 pc = p;
    vec3 pb1 = p;
    vec3 pb2 = p;
    float m = mask(mp);
    

    pb1 = transform_box1(pb1);

	pb2 = transform_box2(pb2);
  
    float b = box(pb1, vec3(.2, 9., .2))-.1;
    float b2 = box(pb2, vec3(.1, .1, 100))-.1;


    mat = m < b ? 0 : 1 ;
    mat = b2 < m ? 2 : mat ;

    inter = b < b2 ? pb1 : pb2;
    
    pc += vec3(0, -4.5, 0);
    
 
    pc.yz *= rot(-.5);
    vec3 pf = pc;

    pc.yz *= rot(PI*.5);

    float c=  cylc(pc, 1.5, .2); 
    float ci = cylc(pc, 1.4, .3);
    float cd = cylc(pc+vec3(0., -.3, -.1), 1.5, .1);
    c = max(c, -ci);

    pf.xy = moda(pf.xy, 7., 0., fid);
    pf.x = abs(pf.x) - 3.4*SIN(tt*.5);
    
    float f = box(pf-vec3(0, 0, fid/200.), vec3(1.9,1.9, .1))*.6;
    
    f = min(max(c, -ci), max(f, ci));
    if(f < b && f < m) mat = 3;
    inter = f < b ? pc : inter;
    float d = min(min(min(m, b), b2), f);
    
	mat = cd < d ? 4 : mat;
    d = min(d, cd);
    return d;
    

}


float ldist(vec2 p, float m) {
	return pow(pow(p.x, m)+pow(p.y, m), 1./m);
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    tt = iTime;
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.x;
    
    vec3 ro = vec3(0, 0, -16),
         rd = normalize(vec3(uv,.7)),
         lp = vec3(-1., 1., -8.);
    vec3 col;
    float i, t, d = 0.1;


    vec3 p = ro;
    
    for(i=0.; i<50.; i++) {
    
        d = map(p);
        
        if(d < 0.001 || t > 40.) break;
        	
        p += rd*d;
        t += d;
    }
    
    vec2 e = vec2(0.0035, -0.0035);
    vec3 base_color;
    int cmat  = mat;
    bool no_dream = cmat == 4 && fract(tt/(8.*PI)) < .5;
    
    if(d < 0.001 && p.z < 3.3 && !no_dream) {
        vec3 n = normalize( e.xyy*map(p+e.xyy) + e.yyx*map(p+e.yyx) +
                            e.yxy*map(p+e.yxy) + e.xxx*map(p+e.xxx));
        
        vec3 l = normalize(lp-p);
        float dif = max(dot(n, l), .0);
        float spe = pow(max(dot(reflect(-rd, n), -l), .0), 50.);
        float sss = smoothstep(0.0, 1.0, map(p + l*0.4));
        
		float fr = pow(1.+dot(n, rd), 2.);

        float sssf = .2;
    
        if(cmat == 0 && p.z < 0.) {
            base_color = vec3(1);   
            p = transform_mask(p);
       		base_color *= mask_texture(p.xy);
        
            if(mod(id, 2.) == 0.) {
          	    base_color = 1.-base_color;
       	    }
        } else if(cmat == 1){
            p = transform_box1(p);
            base_color = vec3(.01+dots(p.xy, .3, 2.));
        } else if( mat == 2) {
            p = transform_box2(p);

           base_color = vec3(dots(p.yz, .15, 1.2));
        } else if (cmat ==3){
        	base_color = vec3(.6);
            sssf = .5;
        }
        col += base_color*dif+.5*spe+sssf*sss;
        col *= 1.3;
        
        if(cmat == 4 && fract(tt/(8.*PI)) > .5) {
            col = dream(inter.xz);
        }


    } else {
	
      // Background is a pseudo 3d torus
      col = leaf_layers(uv)*.6;
      col += 1.5*pow((1.-ldist(abs(uv), .8)), 10.);
      
    }
    
	//col = vec3(dots(uv));
    fragColor = vec4(col, 1.);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


